/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.pay.web.alipay;

import com.alipay.api.AlipayApiException;
import com.alipay.api.internal.util.AlipaySignature;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import net.guerlab.commons.number.NumberHelper;
import net.guerlab.smart.pay.core.enums.PayStatus;
import net.guerlab.smart.pay.core.exception.AlipayConfigInvalidException;
import net.guerlab.smart.pay.service.entity.AlipayConfig;
import net.guerlab.smart.pay.service.entity.PayLog;
import net.guerlab.smart.pay.service.entity.PayLogNotify;
import net.guerlab.smart.pay.service.service.NotifyOriginalLogService;
import net.guerlab.smart.pay.service.service.PayLogNotifyService;
import net.guerlab.smart.pay.service.service.PayLogService;
import net.guerlab.smart.pay.web.alipay.AbstractAlipayController;
import net.guerlab.spring.web.annotation.IgnoreResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;

public abstract class AbstractAlipayNotifyController
extends AbstractAlipayController {
    private static final Logger log = LoggerFactory.getLogger(AbstractAlipayNotifyController.class);
    private static final String TRADE_SUCCESS = "TRADE_SUCCESS";
    private static final String PARAMS_KEY_TRADE_STATUS = "trade_status";
    private PayLogService logService;
    private PayLogNotifyService notifyService;
    private NotifyOriginalLogService notifyOriginalLogService;

    private static boolean rsaCheck(AlipayConfig config, Map<String, String[]> requestParams) {
        if (requestParams == null) {
            return false;
        }
        Map<String, String> params = requestParams.entrySet().stream().filter(AbstractAlipayNotifyController::entryCheck).collect(Collectors.toMap(Map.Entry::getKey, e -> String.join((CharSequence)",", (CharSequence[])e.getValue())));
        try {
            return AlipaySignature.rsaCheckV1(params, (String)config.getAlipayPublicKey(), (String)"UTF-8", (String)"RSA2");
        }
        catch (AlipayApiException e2) {
            log.debug(e2.getMessage(), (Throwable)e2);
            return false;
        }
    }

    private static boolean entryCheck(Map.Entry<String, String[]> entry) {
        return entry != null && entry.getKey() != null && entry.getValue() != null;
    }

    @Operation(description="\u56de\u8c03\u901a\u77e5")
    @PostMapping(value={"/{appId}"})
    @IgnoreResponseHandler
    public final String notify(@Parameter(name="\u652f\u4ed8\u5b9d\u5e94\u7528ID", required=true) @PathVariable String appId, HttpServletRequest request) {
        String result = this.notify0(appId, request);
        this.notifyOriginalLogService.add(this.getPayChannel(), (Object)request.getParameterMap(), result);
        return result;
    }

    protected final String notify0(String appId, HttpServletRequest request) {
        long payLogId;
        if (!TRADE_SUCCESS.equals(request.getParameter(PARAMS_KEY_TRADE_STATUS))) {
            return "ignore trade status";
        }
        AlipayConfig config = (AlipayConfig)this.configService.selectByIdOptional((Serializable)((Object)appId)).orElseThrow(AlipayConfigInvalidException::new);
        if (!AbstractAlipayNotifyController.rsaCheck(config, request.getParameterMap())) {
            return "sign invalid";
        }
        try {
            payLogId = Long.parseLong(request.getParameter("out_trade_no"));
        }
        catch (Exception e) {
            return e.getLocalizedMessage();
        }
        BigDecimal amount = new BigDecimal(request.getParameter("total_amount"));
        String notifyAppId = request.getParameter("app_id");
        if (!appId.equals(notifyAppId)) {
            return "appId not equals";
        }
        PayLog payLog = (PayLog)this.logService.selectById((Serializable)Long.valueOf(payLogId));
        if (payLog == null) {
            return "payLog invalid";
        }
        if (!Objects.equals(this.getPayChannel(), payLog.getPayChannel())) {
            return "payLog payChannel error, need: " + payLog.getPayChannel() + ", input: " + this.getPayChannel();
        }
        if (!NumberHelper.isEquals((Comparable)amount, (Comparable)payLog.getAmount())) {
            return "payLog amount error, need: " + payLog.getAmount() + ", input: " + amount;
        }
        if (!appId.equals(payLog.getExtend().get((Object)"appId"))) {
            return "payLog appId error, need: " + payLog.getExtend() + ", input: " + appId;
        }
        if (payLog.getPayStatus() != PayStatus.WAIT_PAY) {
            return "payLog status error: " + payLog.getPayStatus();
        }
        PayLogNotify payLogNotify = PayLogNotify.buildByPayLog((PayLog)payLog);
        payLogNotify.setOutOrderSn(request.getParameter("trade_no"));
        try {
            this.notifyService.insert((Object)payLogNotify);
        }
        catch (Exception e) {
            log.debug(e.getLocalizedMessage(), (Throwable)e);
        }
        this.logService.payed(payLog);
        return "success";
    }

    @Autowired
    public void setLogService(PayLogService logService) {
        this.logService = logService;
    }

    @Autowired
    public void setNotifyService(PayLogNotifyService notifyService) {
        this.notifyService = notifyService;
    }

    @Autowired
    public void setNotifyOriginalLogService(NotifyOriginalLogService notifyOriginalLogService) {
        this.notifyOriginalLogService = notifyOriginalLogService;
    }
}

