/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.pay.web.controller.user;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.Serializable;
import java.util.Collection;
import javax.servlet.http.HttpServletResponse;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.pay.core.domain.PayLogNotifyDTO;
import net.guerlab.smart.pay.core.exception.ExceptionReasonInvalidException;
import net.guerlab.smart.pay.core.exception.ExceptionReasonLengthErrorException;
import net.guerlab.smart.pay.core.exception.PayLogNotifyInvalidException;
import net.guerlab.smart.pay.core.searchparams.PayLogNotifySearchParams;
import net.guerlab.smart.pay.service.entity.PayLogNotify;
import net.guerlab.smart.pay.service.service.PayLogNotifyService;
import net.guerlab.smart.pay.web.domain.ExceptionDTO;
import net.guerlab.smart.pay.web.excel.PayLogNotifyExcelExport;
import net.guerlab.smart.platform.excel.ExcelUtils;
import net.guerlab.smart.platform.server.controller.BaseFindController;
import net.guerlab.smart.user.api.OperationLogApi;
import net.guerlab.smart.user.auth.UserContextHandler;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u652f\u4ed8\u8bb0\u5f55\u901a\u77e5")
@RestController(value="/user/payLogNotify")
@RequestMapping(value={"/user/payLogNotify"})
public class PayLogNotifyController
extends BaseFindController<PayLogNotifyDTO, PayLogNotify, PayLogNotifyService, PayLogNotifySearchParams, Long> {
    private OperationLogApi operationLogApi;

    @Operation(description="\u5bfc\u51faExcel", security={@SecurityRequirement(name="Authorization")})
    @GetMapping(value={"/exportExcel"})
    public void exportExcel(HttpServletResponse response, PayLogNotifySearchParams searchParams) {
        this.beforeFind((AbstractSearchParams)searchParams);
        ExcelUtils.exportExcel((HttpServletResponse)response, (Collection)((PayLogNotifyService)this.getService()).selectAll((AbstractSearchParams)searchParams), PayLogNotifyExcelExport.class, (String)("PayLogNotify-" + System.currentTimeMillis()));
        this.operationLogApi.add("\u5bfc\u51fa\u652f\u4ed8\u8bb0\u5f55\u901a\u77e5\u5217\u8868", UserContextHandler.getUserId(), new Object[]{searchParams});
    }

    @Operation(description="\u6807\u8bb0\u5f02\u5e38", security={@SecurityRequirement(name="Authorization")})
    @PostMapping(value={"/{id}/markException"})
    @Transactional(rollbackFor={Exception.class})
    public PayLogNotifyDTO markException(@Parameter(name="id", required=true) @PathVariable Long id, @RequestBody ExceptionDTO dto) {
        String reason = StringUtils.trimToNull((String)dto.getReason());
        if (reason == null) {
            throw new ExceptionReasonInvalidException();
        }
        if (reason.length() > 255) {
            throw new ExceptionReasonLengthErrorException();
        }
        this.findOne0((Serializable)id);
        ((PayLogNotifyService)this.getService()).markException(id, reason);
        this.operationLogApi.add("\u6807\u8bb0\u5f02\u5e38-\u652f\u4ed8\u8bb0\u5f55\u901a\u77e5", UserContextHandler.getUserId(), new Object[]{id, reason});
        return (PayLogNotifyDTO)((PayLogNotify)this.findOne0((Serializable)id)).convert();
    }

    @Operation(description="\u79fb\u9664\u6807\u8bb0\u5f02\u5e38", security={@SecurityRequirement(name="Authorization")})
    @PostMapping(value={"/{id}/removeMarkException"})
    @Transactional(rollbackFor={Exception.class})
    public PayLogNotifyDTO removeMarkException(@Parameter(name="id", required=true) @PathVariable Long id) {
        this.findOne0((Serializable)id);
        ((PayLogNotifyService)this.getService()).removeExceptionMark(id);
        this.operationLogApi.add("\u79fb\u9664\u5f02\u5e38\u6807\u8bb0-\u652f\u4ed8\u8bb0\u5f55\u901a\u77e5", UserContextHandler.getUserId(), new Object[]{id});
        return (PayLogNotifyDTO)((PayLogNotify)this.findOne0((Serializable)id)).convert();
    }

    protected ApplicationException nullPointException() {
        return new PayLogNotifyInvalidException();
    }

    @Autowired
    public void setOperationLogApi(OperationLogApi operationLogApi) {
        this.operationLogApi = operationLogApi;
    }
}

