/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.pay.web.controller.user;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.Serializable;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.pay.core.domain.AlipayConfigDTO;
import net.guerlab.smart.pay.core.exception.AlipayConfigInvalidException;
import net.guerlab.smart.pay.core.searchparams.AlipayConfigSearchParams;
import net.guerlab.smart.pay.service.entity.AlipayConfig;
import net.guerlab.smart.pay.service.service.AlipayConfigService;
import net.guerlab.smart.platform.server.controller.BaseController;
import net.guerlab.smart.user.api.OperationLogApi;
import net.guerlab.smart.user.auth.UserContextHandler;
import net.guerlab.spring.commons.dto.Convert;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u652f\u4ed8\u5b9d\u652f\u4ed8\u914d\u7f6e")
@RestController(value="/user/alipayConfig")
@RequestMapping(value={"/user/alipayConfig"})
public class AlipayConfigController
extends BaseController<AlipayConfigDTO, AlipayConfig, AlipayConfigService, AlipayConfigSearchParams, String> {
    private OperationLogApi operationLogApi;

    @Operation(description="\u542f\u7528\u914d\u7f6e", security={@SecurityRequirement(name="Authorization")})
    @PostMapping(value={"/{id}/enable"})
    public AlipayConfigDTO enable(@Parameter(name="id", required=true) @PathVariable String id) {
        AlipayConfig entity = (AlipayConfig)this.findOne0((Serializable)((Object)id));
        entity.setEnable(Boolean.valueOf(true));
        ((AlipayConfigService)this.getService()).updateById((Object)entity);
        this.operationLogApi.add("\u542f\u7528\u652f\u4ed8\u5b9d\u652f\u4ed8\u914d\u7f6e", UserContextHandler.getUserId(), new Object[]{id});
        return (AlipayConfigDTO)entity.convert();
    }

    @Operation(description="\u7981\u7528\u914d\u7f6e", security={@SecurityRequirement(name="Authorization")})
    @PostMapping(value={"/{id}/disable"})
    public AlipayConfigDTO disable(@Parameter(name="id", required=true) @PathVariable String id) {
        AlipayConfig entity = (AlipayConfig)this.findOne0((Serializable)((Object)id));
        entity.setEnable(Boolean.valueOf(false));
        ((AlipayConfigService)this.getService()).updateById((Object)entity);
        this.operationLogApi.add("\u7981\u7528\u652f\u4ed8\u5b9d\u652f\u4ed8\u914d\u7f6e", UserContextHandler.getUserId(), new Object[]{id});
        return (AlipayConfigDTO)entity.convert();
    }

    protected ApplicationException nullPointException() {
        return new AlipayConfigInvalidException();
    }

    public void copyProperties(AlipayConfigDTO dto, AlipayConfig entity, String id) {
        super.copyProperties((Object)dto, (Convert)entity, (Serializable)((Object)id));
        if (id != null) {
            entity.setAppId(id);
        }
    }

    public void afterSave(AlipayConfig entity, AlipayConfigDTO dto) {
        this.operationLogApi.add("\u65b0\u589e\u652f\u4ed8\u5b9d\u652f\u4ed8\u914d\u7f6e", UserContextHandler.getUserId(), new Object[]{entity});
    }

    public void afterUpdate(AlipayConfig entity, AlipayConfigDTO dto) {
        this.operationLogApi.add("\u7f16\u8f91\u652f\u4ed8\u5b9d\u652f\u4ed8\u914d\u7f6e", UserContextHandler.getUserId(), new Object[]{entity});
    }

    public void afterDelete(AlipayConfig entity) {
        this.operationLogApi.add("\u5220\u9664\u652f\u4ed8\u5b9d\u652f\u4ed8\u914d\u7f6e", UserContextHandler.getUserId(), new Object[]{entity.getAppId()});
    }

    @Autowired
    public void setOperationLogApi(OperationLogApi operationLogApi) {
        this.operationLogApi = operationLogApi;
    }
}

