/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.pay.web.controller.commons.pay.alipay;

import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayObject;
import com.alipay.api.AlipayRequest;
import com.alipay.api.domain.AlipayTradeAppPayModel;
import com.alipay.api.request.AlipayTradeAppPayRequest;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.servlet.http.HttpServletRequest;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.pay.service.entity.PayLog;
import net.guerlab.smart.pay.web.alipay.AbstractAlipayRequestController;
import net.guerlab.smart.pay.web.alipay.AlipayTradeType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u652f\u4ed8\u8bf7\u6c42-\u652f\u4ed8\u5b9d-app")
@RestController(value="/commons/pay/alipay/app")
@RequestMapping(value={"/commons/pay/alipay/app"})
public class AlipayAppPayController
extends AbstractAlipayRequestController {
    public static final String URL = "/commons/pay/alipay/app";

    protected Object pay0(String appId, PayLog payLog, String returnUrl, HttpServletRequest request) {
        AlipayTradeAppPayModel bizModel = new AlipayTradeAppPayModel();
        bizModel.setOutTradeNo(String.valueOf(payLog.getPayLogId()));
        bizModel.setProductCode("QUICK_MSECURITY_PAY");
        bizModel.setTotalAmount(payLog.getAmount().toString());
        bizModel.setSubject(payLog.getOrderTitle());
        AlipayTradeAppPayRequest payRequest = new AlipayTradeAppPayRequest();
        payRequest.setNotifyUrl(this.payProperties.getNotifyUrl() + this.getNotifyUrl(appId));
        if (returnUrl != null) {
            payRequest.setReturnUrl(returnUrl);
        }
        payRequest.setBizModel((AlipayObject)bizModel);
        try {
            return this.buildAlipayClient(appId, true).sdkExecute((AlipayRequest)payRequest);
        }
        catch (AlipayApiException e) {
            throw new ApplicationException(e.getErrCode() + ":" + e.getErrMsg());
        }
    }

    protected String getNotifyUrl(String appId) {
        return "/commons/notify/alipay/app/" + appId;
    }

    protected AlipayTradeType getAlipayTradeType() {
        return AlipayTradeType.APP;
    }
}

