package net.guerlab.smart.pay.web.controller.user;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.pay.core.domain.NotifyOriginalLogDTO;
import net.guerlab.smart.pay.core.exception.NotifyOriginalLogInvalidException;
import net.guerlab.smart.pay.core.searchparams.NotifyOriginalLogSearchParams;
import net.guerlab.smart.pay.service.entity.NotifyOriginalLog;
import net.guerlab.smart.pay.service.service.NotifyOriginalLogService;
import net.guerlab.smart.pay.web.excel.NotifyOriginalLogExcelExport;
import net.guerlab.smart.platform.excel.ExcelUtils;
import net.guerlab.smart.platform.server.controller.BaseFindController;
import net.guerlab.smart.user.api.OperationLogApi;
import net.guerlab.smart.user.auth.UserContextHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;

/**
 * 通知原始记录
 *
 * @author guer
 */
@Api(tags = "通知原始记录")
@RestController("/user/notifyOriginalLog")
@RequestMapping("/user/notifyOriginalLog")
public class NotifyOriginalLogController
        extends BaseFindController<NotifyOriginalLogDTO, NotifyOriginalLog, NotifyOriginalLogService, NotifyOriginalLogSearchParams, Long> {

    private OperationLogApi operationLogApi;

    @ApiOperation("导出Excel")
    @GetMapping("/exportExcel")
    public void exportExcel(HttpServletResponse response, NotifyOriginalLogSearchParams searchParams) {
        beforeFind(searchParams);
        ExcelUtils.exportExcel(response, getService().selectAll(searchParams), NotifyOriginalLogExcelExport.class,
                "NotifyOriginalLog-" + System.currentTimeMillis());
        operationLogApi.add("导出通知原始记录列表", UserContextHandler.getUserId(), searchParams);
    }

    @Override
    protected ApplicationException nullPointException() {
        return new NotifyOriginalLogInvalidException();
    }

    @SuppressWarnings("SpringJavaInjectionPointsAutowiringInspection")
    @Autowired
    public void setOperationLogApi(OperationLogApi operationLogApi) {
        this.operationLogApi = operationLogApi;
    }
}
