/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.pay.web.controller.user;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Base64;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.pay.core.domain.WxPayConfigDTO;
import net.guerlab.smart.pay.core.exception.WxPayConfigInvalidException;
import net.guerlab.smart.pay.core.searchparams.WxPayConfigSearchParams;
import net.guerlab.smart.pay.service.entity.WxPayConfig;
import net.guerlab.smart.pay.service.service.WxPayConfigService;
import net.guerlab.smart.platform.auth.annotation.IgnoreLogin;
import net.guerlab.smart.platform.server.controller.BaseController;
import net.guerlab.smart.user.api.OperationLogApi;
import net.guerlab.smart.user.auth.UserContextHandler;
import net.guerlab.spring.commons.dto.ConvertDTO;
import net.guerlab.web.result.Fail;
import net.guerlab.web.result.Result;
import net.guerlab.web.result.Succeed;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u5fae\u4fe1\u652f\u4ed8\u914d\u7f6e"})
@RestController(value="/user/wxPayConfig")
@RequestMapping(value={"/user/wxPayConfig"})
public class WxPayConfigController
extends BaseController<WxPayConfigDTO, WxPayConfig, WxPayConfigService, WxPayConfigSearchParams, String> {
    private OperationLogApi operationLogApi;

    @IgnoreLogin
    @ApiOperation(value="\u89e3\u6790\u8bc1\u4e66\u6587\u4ef6base64")
    @PostMapping(value={"/parseCertFile"})
    public Result<String> parseCertFile(MultipartFile file) {
        try {
            return new Succeed("success", (Object)Base64.getEncoder().encodeToString(file.getBytes()));
        }
        catch (Exception e) {
            return new Fail(e.getMessage());
        }
    }

    @ApiOperation(value="\u542f\u7528\u914d\u7f6e")
    @PostMapping(value={"/{id}/enable"})
    public WxPayConfigDTO enable(@ApiParam(value="id", required=true) @PathVariable String id) {
        WxPayConfig entity = (WxPayConfig)this.findOne0((Object)id);
        entity.setEnable(Boolean.valueOf(true));
        ((WxPayConfigService)this.getService()).updateSelectiveById((Object)entity);
        this.operationLogApi.add("\u542f\u7528\u5fae\u4fe1\u652f\u4ed8\u914d\u7f6e", UserContextHandler.getUserId(), new Object[]{id});
        return (WxPayConfigDTO)entity.toDTO();
    }

    @ApiOperation(value="\u7981\u7528\u914d\u7f6e")
    @PostMapping(value={"/{id}/disable"})
    public WxPayConfigDTO disable(@ApiParam(value="id", required=true) @PathVariable String id) {
        WxPayConfig entity = (WxPayConfig)this.findOne0((Object)id);
        entity.setEnable(Boolean.valueOf(false));
        ((WxPayConfigService)this.getService()).updateSelectiveById((Object)entity);
        this.operationLogApi.add("\u7981\u7528\u5fae\u4fe1\u652f\u4ed8\u914d\u7f6e", UserContextHandler.getUserId(), new Object[]{id});
        return (WxPayConfigDTO)entity.toDTO();
    }

    protected ApplicationException nullPointException() {
        return new WxPayConfigInvalidException();
    }

    public void copyProperties(WxPayConfigDTO dto, WxPayConfig entity, String id) {
        super.copyProperties((Object)dto, (ConvertDTO)entity, (Object)id);
        if (id != null) {
            entity.setAppId(id);
        }
    }

    public void afterSave(WxPayConfig entity, WxPayConfigDTO dto) {
        this.operationLogApi.add("\u65b0\u589e\u5fae\u4fe1\u652f\u4ed8\u914d\u7f6e", UserContextHandler.getUserId(), new Object[]{entity});
    }

    public void afterUpdate(WxPayConfig entity, WxPayConfigDTO dto) {
        this.operationLogApi.add("\u7f16\u8f91\u5fae\u4fe1\u652f\u4ed8\u914d\u7f6e", UserContextHandler.getUserId(), new Object[]{entity});
    }

    public void afterDelete(WxPayConfig entity) {
        this.operationLogApi.add("\u5220\u9664\u5fae\u4fe1\u652f\u4ed8\u914d\u7f6e", UserContextHandler.getUserId(), new Object[]{entity.getAppId()});
    }

    @Autowired
    public void setOperationLogApi(OperationLogApi operationLogApi) {
        this.operationLogApi = operationLogApi;
    }
}

