/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.pay.web.controller.user;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.Collection;
import javax.servlet.http.HttpServletResponse;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.pay.core.domain.PayLogExtends;
import net.guerlab.smart.pay.core.domain.PayOrderDTO;
import net.guerlab.smart.pay.core.enums.PayStatus;
import net.guerlab.smart.pay.core.exception.ExceptionReasonInvalidException;
import net.guerlab.smart.pay.core.exception.ExceptionReasonLengthErrorException;
import net.guerlab.smart.pay.core.exception.PayOrderInvalidException;
import net.guerlab.smart.pay.core.exception.PayStatusErrorException;
import net.guerlab.smart.pay.core.searchparams.PayOrderSearchParams;
import net.guerlab.smart.pay.service.entity.PayLog;
import net.guerlab.smart.pay.service.entity.PayOrder;
import net.guerlab.smart.pay.service.service.PayLogService;
import net.guerlab.smart.pay.service.service.PayOrderService;
import net.guerlab.smart.pay.stream.binders.PayOrderStatusChangeSenderChannel;
import net.guerlab.smart.pay.web.domain.ExceptionDTO;
import net.guerlab.smart.pay.web.excel.PayOrderExcelExport;
import net.guerlab.smart.platform.excel.ExcelUtils;
import net.guerlab.smart.platform.server.controller.BaseFindController;
import net.guerlab.smart.platform.stream.utils.MessageUtils;
import net.guerlab.smart.platform.user.api.OperationLogApi;
import net.guerlab.smart.platform.user.auth.UserContextHandler;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.messaging.MessageChannel;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u652f\u4ed8\u8ba2\u5355"})
@RestController(value="/user/payOrder")
@RequestMapping(value={"/user/payOrder"})
@EnableBinding(value={PayOrderStatusChangeSenderChannel.class})
public class PayOrderController
extends BaseFindController<PayOrderDTO, PayOrder, PayOrderService, PayOrderSearchParams, Long> {
    private PayLogService logService;
    private PayOrderStatusChangeSenderChannel statusChangeSender;
    private OperationLogApi operationLogApi;

    protected ApplicationException nullPointException() {
        return new PayOrderInvalidException();
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/exportExcel"})
    public void exportExcel(HttpServletResponse response, PayOrderSearchParams searchParams) throws IOException {
        this.beforeFind((AbstractSearchParams)searchParams);
        ExcelUtils.exportExcel((HttpServletResponse)response, (Collection)((PayOrderService)this.getService()).selectAll((AbstractSearchParams)searchParams), PayOrderExcelExport.class, (String)("PayOrder-" + System.currentTimeMillis()));
        this.operationLogApi.add("\u5bfc\u51fa\u652f\u4ed8\u8ba2\u5355\u5217\u8868", UserContextHandler.getUserId(), new Object[]{searchParams});
    }

    @ApiOperation(value="\u786e\u8ba4\u652f\u4ed8")
    @PostMapping(value={"/{id}/confirmPayed"})
    @Transactional(rollbackFor={Exception.class})
    public PayOrderDTO confirmPayed(@ApiParam(value="id", required=true) @PathVariable Long id) {
        PayOrder payOrder = (PayOrder)this.findOne0(id);
        if (payOrder.getPayStatus() != PayStatus.WAIT_PAY) {
            throw new PayStatusErrorException();
        }
        PayLogExtends payLogExtends = new PayLogExtends();
        payLogExtends.put((Object)"operation_userId", (Object)UserContextHandler.getUserIdString());
        payLogExtends.put((Object)"operation_name", (Object)UserContextHandler.getName());
        payLogExtends.put((Object)"operation_departmentId", (Object)UserContextHandler.getDepartmentIdString());
        payLogExtends.put((Object)"operation_departmentName", (Object)UserContextHandler.getDepartmentName());
        PayLog payLog = this.logService.create(id, "MANUAL_CONFIRM", payLogExtends);
        payLog.setVersion(Long.valueOf(1L));
        this.logService.payed(payLog);
        this.operationLogApi.add("\u786e\u8ba4\u652f\u4ed8", UserContextHandler.getUserId(), new Object[]{payOrder});
        return (PayOrderDTO)((PayOrder)this.findOne0(id)).toDTO();
    }

    @ApiOperation(value="\u6807\u8bb0\u5f02\u5e38")
    @PostMapping(value={"/{id}/markException"})
    @Transactional(rollbackFor={Exception.class})
    public PayOrderDTO markException(@ApiParam(value="id", required=true) @PathVariable Long id, @RequestBody ExceptionDTO dto) {
        String reason = StringUtils.trimToNull((String)dto.getReason());
        if (reason == null) {
            throw new ExceptionReasonInvalidException();
        }
        if (reason.length() > 255) {
            throw new ExceptionReasonLengthErrorException();
        }
        this.findOne0(id);
        ((PayOrderService)this.getService()).markException(id, reason);
        this.operationLogApi.add("\u652f\u4ed8\u8ba2\u5355-\u6807\u8bb0\u5f02\u5e38", UserContextHandler.getUserId(), new Object[]{id, reason});
        return (PayOrderDTO)((PayOrder)this.findOne0(id)).toDTO();
    }

    @ApiOperation(value="\u79fb\u9664\u6807\u8bb0\u5f02\u5e38")
    @PostMapping(value={"/{id}/removeMarkException"})
    @Transactional(rollbackFor={Exception.class})
    public PayOrderDTO removeMarkException(@ApiParam(value="id", required=true) @PathVariable Long id) {
        this.findOne0(id);
        ((PayOrderService)this.getService()).removeExceptionMark(id);
        this.operationLogApi.add("\u652f\u4ed8\u8ba2\u5355-\u79fb\u9664\u5f02\u5e38\u6807\u8bb0", UserContextHandler.getUserId(), new Object[]{id});
        return (PayOrderDTO)((PayOrder)this.findOne0(id)).toDTO();
    }

    @ApiOperation(value="\u540c\u6b65\u8ba2\u5355\u4fe1\u606f")
    @PostMapping(value={"/{id}/sync"})
    public void sync(@ApiParam(value="id", required=true) @PathVariable Long id) {
        MessageUtils.send((MessageChannel)this.statusChangeSender.output(), (Object)((PayOrder)this.findOne0(id)));
        this.operationLogApi.add("\u652f\u4ed8\u8ba2\u5355-\u540c\u6b65\u8ba2\u5355\u4fe1\u606f", UserContextHandler.getUserId(), new Object[]{id});
    }

    @Autowired
    public void setLogService(PayLogService logService) {
        this.logService = logService;
    }

    @Autowired
    public void setStatusChangeSender(PayOrderStatusChangeSenderChannel statusChangeSender) {
        this.statusChangeSender = statusChangeSender;
    }

    @Autowired
    public void setOperationLogApi(OperationLogApi operationLogApi) {
        this.operationLogApi = operationLogApi;
    }
}

