/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.pay.web.alipay;

import com.alipay.api.AlipayClient;
import com.alipay.api.DefaultAlipayClient;
import net.guerlab.smart.pay.core.exception.AlipayConfigInvalidException;
import net.guerlab.smart.pay.service.entity.AlipayConfig;
import net.guerlab.smart.pay.service.properties.PayProperties;
import net.guerlab.smart.pay.service.service.AlipayConfigService;
import net.guerlab.smart.pay.web.alipay.AlipayTradeType;
import net.guerlab.smart.pay.web.alipay.AlipayUrlConstants;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractAlipayController {
    protected static final String KEY_APP_ID = "appId";
    protected AlipayConfigService configService;
    protected PayProperties payProperties;

    final String getPayChannel() {
        return "ALIPAY_" + this.getAlipayTradeType().name();
    }

    protected abstract AlipayTradeType getAlipayTradeType();

    protected AlipayClient buildAlipayClient(String appId) {
        return this.buildAlipayClient(appId, false);
    }

    protected AlipayClient buildAlipayClient(AlipayConfig config) {
        return this.buildAlipayClient(config, false);
    }

    protected AlipayClient buildAlipayClient(String appId, boolean checkEnable) {
        return this.buildAlipayClient((AlipayConfig)this.configService.selectByIdOptional((Object)appId).orElseThrow(AlipayConfigInvalidException::new), checkEnable);
    }

    protected AlipayClient buildAlipayClient(AlipayConfig config, boolean checkEnable) {
        if (config == null) {
            throw new AlipayConfigInvalidException();
        }
        if (checkEnable && !config.getEnable().booleanValue()) {
            throw new AlipayConfigInvalidException();
        }
        String gatewayUrl = AlipayUrlConstants.gateway((boolean)config.getEnableDevEnv());
        return new DefaultAlipayClient(gatewayUrl, config.getAppId(), config.getPrivateKey(), "json", "UTF-8", config.getAlipayPublicKey(), "RSA2");
    }

    @Autowired
    public void setConfigService(AlipayConfigService configService) {
        this.configService = configService;
    }

    @Autowired
    public void setPayProperties(PayProperties payProperties) {
        this.payProperties = payProperties;
    }
}

