package net.guerlab.smart.pay.web.controller.commons.pay.wx;

import io.swagger.annotations.Api;
import net.guerlab.smart.pay.web.controller.commons.notify.wx.WxPayNativeChannelNotifyController;
import net.guerlab.smart.pay.web.wx.AbstractWxPayRequestController;
import net.guerlab.smart.pay.web.wx.WxPayServiceType;
import net.guerlab.smart.platform.basic.auth.annotation.IgnoreLogin;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 支付请求-微信-native
 *
 * @author guer
 */
@IgnoreLogin
@Api(tags = "支付请求-微信-native")
@RestController("/commons/payRequest/native")
@RequestMapping("/commons/payRequest/native")
public class WxPayNativeChannelPayController extends AbstractWxPayRequestController {

    @Override
    protected WxPayServiceType getWxPayServiceType() {
        return WxPayServiceType.NATIVE;
    }

    @Override
    public String getNotifyUrl(String appId) {
        return WxPayNativeChannelNotifyController.URL + "/" + appId;
    }
}
