package net.guerlab.smart.pay.web.controller.wx;

import io.swagger.annotations.Api;
import net.guerlab.smart.pay.web.controller.commons.notify.wx.WxPayMiniAppChannelNotifyController;
import net.guerlab.smart.pay.web.wx.AbstractWxPayRequestController;
import net.guerlab.smart.pay.web.wx.WxPayServiceType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 支付请求-微信-小程序
 *
 * @author guer
 */
@Api(tags = "支付请求-微信-小程序")
@RestController("/wx/payRequest/miniApp")
@RequestMapping("/wx/payRequest/miniApp")
public class WxPayMiniAppChannelPayController extends AbstractWxPayRequestController {

    @Override
    protected WxPayServiceType getWxPayServiceType() {
        return WxPayServiceType.MINI_APP;
    }

    @Override
    public String getNotifyUrl(String appId) {
        return WxPayMiniAppChannelNotifyController.URL + "/" + appId;
    }
}
