package net.guerlab.smart.pay.web.controller.user;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.pay.core.domain.AlipayConfigDTO;
import net.guerlab.smart.pay.core.exception.AlipayConfigInvalidException;
import net.guerlab.smart.pay.core.searchparams.AlipayConfigSearchParams;
import net.guerlab.smart.pay.service.entity.AlipayConfig;
import net.guerlab.smart.pay.service.service.AlipayConfigService;
import net.guerlab.smart.platform.server.controller.BaseController;
import net.guerlab.smart.platform.user.api.OperationLogApi;
import net.guerlab.smart.platform.user.auth.UserContextHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 支付宝支付配置
 *
 * @author guer
 */
@Api(tags = "支付宝支付配置")
@RestController("/user/alipayConfig")
@RequestMapping("/user/alipayConfig")
public class AlipayConfigController
        extends BaseController<AlipayConfigDTO, AlipayConfig, AlipayConfigService, AlipayConfigSearchParams, String> {

    private OperationLogApi operationLogApi;

    @ApiOperation("启用配置")
    @PostMapping("/{id}/enable")
    public AlipayConfigDTO enable(@ApiParam(value = "id", required = true) @PathVariable String id) {
        AlipayConfig entity = findOne0(id);
        entity.setEnable(true);
        getService().updateSelectiveById(entity);
        operationLogApi.add("启用支付宝支付配置", UserContextHandler.getUserId(), id);
        return entity.toDTO();
    }

    @ApiOperation("禁用配置")
    @PostMapping("/{id}/disable")
    public AlipayConfigDTO disable(@ApiParam(value = "id", required = true) @PathVariable String id) {
        AlipayConfig entity = findOne0(id);
        entity.setEnable(false);
        getService().updateSelectiveById(entity);
        operationLogApi.add("禁用支付宝支付配置", UserContextHandler.getUserId(), id);
        return entity.toDTO();
    }

    @Override
    protected ApplicationException nullPointException() {
        return new AlipayConfigInvalidException();
    }

    @Override
    public void copyProperties(AlipayConfigDTO dto, AlipayConfig entity, String id) {
        super.copyProperties(dto, entity, id);
        if (id != null) {
            entity.setAppId(id);
        }
    }

    @Override
    public void afterSave(AlipayConfig entity, AlipayConfigDTO dto) {
        operationLogApi.add("新增支付宝支付配置", UserContextHandler.getUserId(), entity);
    }

    @Override
    public void afterUpdate(AlipayConfig entity, AlipayConfigDTO dto) {
        operationLogApi.add("编辑支付宝支付配置", UserContextHandler.getUserId(), entity);
    }

    @Override
    public void afterDelete(AlipayConfig entity) {
        operationLogApi.add("删除支付宝支付配置", UserContextHandler.getUserId(), entity.getAppId());
    }

    @SuppressWarnings("SpringJavaInjectionPointsAutowiringInspection")
    @Autowired
    public void setOperationLogApi(OperationLogApi operationLogApi) {
        this.operationLogApi = operationLogApi;
    }
}
