package net.guerlab.smart.pay.web.controller.commons.pay.alipay;

import com.alipay.api.AlipayApiException;
import com.alipay.api.domain.AlipayTradeWapPayModel;
import com.alipay.api.request.AlipayTradeWapPayRequest;
import io.swagger.annotations.Api;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.pay.service.entity.PayLog;
import net.guerlab.smart.pay.web.alipay.AbstractAlipayRequestController;
import net.guerlab.smart.pay.web.alipay.AlipayTradeType;
import net.guerlab.smart.pay.web.controller.commons.notify.alipay.AlipayWapChannelNotifyController;
import net.guerlab.web.result.Succeed;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;

/**
 * 支付请求-支付宝-wap
 *
 * @author guer
 */
@Api(tags = "支付请求-支付宝-wap")
@RestController(AlipayWapPayController.URL)
@RequestMapping(AlipayWapPayController.URL)
public class AlipayWapPayController extends AbstractAlipayRequestController {

    public static final String URL = "/commons/pay/alipay/wap";

    @Override
    protected Object pay0(String appId, PayLog payLog, String returnUrl, HttpServletRequest request) {
        AlipayTradeWapPayModel bizModel = new AlipayTradeWapPayModel();
        bizModel.setOutTradeNo(String.valueOf(payLog.getPayLogId()));
        bizModel.setProductCode("QUICK_WAP_WAY");
        bizModel.setTotalAmount(payLog.getAmount().toString());
        bizModel.setSubject(payLog.getOrderTitle());

        AlipayTradeWapPayRequest payRequest = new AlipayTradeWapPayRequest();
        fillRequestData(appId, returnUrl, payRequest, bizModel);
        try {
            return new Succeed<>(Succeed.MSG, buildAlipayClient(appId, true).pageExecute(payRequest).getBody());
        } catch (AlipayApiException e) {
            throw new ApplicationException(e.getErrCode() + ":" + e.getErrMsg());
        }
    }

    @Override
    protected String getNotifyUrl(String appId) {
        return AlipayWapChannelNotifyController.URL + "/" + appId;
    }

    @Override
    protected AlipayTradeType getAlipayTradeType() {
        return AlipayTradeType.WAP;
    }
}
