/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.pay.web.wx;

import com.github.binarywang.wxpay.bean.request.WxPayUnifiedOrderRequest;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.impl.WxPayServiceApacheHttpImpl;
import java.util.Base64;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.commons.random.RandomUtil;
import net.guerlab.smart.pay.service.entity.WxPayConfig;
import net.guerlab.smart.pay.service.properties.PayProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxPayService
extends WxPayServiceApacheHttpImpl {
    private static final Logger log = LoggerFactory.getLogger(WxPayService.class);
    private final PayProperties payProperties;
    private final WxPayConfig properties;

    public WxPayService(PayProperties payProperties, WxPayConfig wxPayConfig) {
        this.payProperties = payProperties;
        this.properties = wxPayConfig;
        this.config = new com.github.binarywang.wxpay.config.WxPayConfig();
        this.config.setAppId(this.properties.getAppId());
        this.config.setMchId(this.properties.getMchId());
        this.config.setMchKey(this.properties.getMchKey());
        this.config.setSubAppId(this.properties.getSubAppId());
        this.config.setSubMchId(this.properties.getSubMchId());
        this.config.setKeyContent(Base64.getDecoder().decode(this.properties.getKeyContentBase64()));
    }

    public <T> T createOrder(WxPayUnifiedOrderRequest request) {
        request.setAppid(this.properties.getAppId());
        request.setMchId(this.properties.getMchId());
        request.setSubAppId(this.properties.getSubAppId());
        request.setSubMchId(this.properties.getSubMchId());
        request.setNonceStr(RandomUtil.nextString((int)6));
        request.setNotifyUrl(this.payProperties.getNotifyUrl() + request.getNotifyUrl());
        try {
            return (T)super.createOrder(request);
        }
        catch (WxPayException e) {
            String res = e.getErrCodeDes();
            if (res == null) {
                res = e.getMessage();
            }
            log.debug(e.getMessage(), (Throwable)e);
            throw new ApplicationException(res);
        }
    }

    public PayProperties getPayProperties() {
        return this.payProperties;
    }

    public WxPayConfig getProperties() {
        return this.properties;
    }
}

