/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.pay.web.alipay;

import com.alipay.api.AlipayObject;
import com.alipay.api.AlipayRequest;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.servlet.http.HttpServletRequest;
import net.guerlab.smart.pay.core.domain.PayLogExtends;
import net.guerlab.smart.pay.service.entity.PayLog;
import net.guerlab.smart.pay.service.service.PayLogService;
import net.guerlab.smart.pay.web.alipay.AbstractAlipayController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

public abstract class AbstractAlipayRequestController
extends AbstractAlipayController {
    private static final Logger log = LoggerFactory.getLogger(AbstractAlipayRequestController.class);
    private PayLogService logService;

    @ApiOperation(value="\u901a\u8fc7\u652f\u4ed8\u8ba2\u5355ID\u8bf7\u6c42\u652f\u4ed8")
    @GetMapping(value={"/byPayOrderId/{appId}/{payOrderId}"})
    public final Object byPayOrderId(@ApiParam(value="\u652f\u4ed8\u5b9d\u5e94\u7528ID", required=true) @PathVariable String appId, @ApiParam(value="\u652f\u4ed8\u8ba2\u5355ID", required=true) @PathVariable Long payOrderId, @ApiParam(value="returnUrl") @RequestParam(required=false) String returnUrl, HttpServletRequest request) {
        PayLog payLog = this.logService.create(payOrderId, this.getPayChannel(), this.createPayLogExtends(appId));
        return this.pay0(appId, payLog, returnUrl, request);
    }

    @ApiOperation(value="\u901a\u8fc7\u4e1a\u52a1\u5206\u7ec4\u548c\u4e1a\u52a1ID\u8bf7\u6c42\u652f\u4ed8")
    @GetMapping(value={"/byBusinessId/{appId}/{businessGroup}/{businessId}"})
    public final Object byBusinessId(@ApiParam(value="\u652f\u4ed8\u5b9d\u5e94\u7528ID", required=true) @PathVariable String appId, @ApiParam(value="\u4e1a\u52a1\u5206\u7ec4", required=true) @PathVariable String businessGroup, @ApiParam(value="\u4e1a\u52a1ID", required=true) @PathVariable String businessId, @ApiParam(value="returnUrl") @RequestParam(required=false) String returnUrl, HttpServletRequest request) {
        PayLog payLog = this.logService.create(businessGroup, businessId, this.getPayChannel(), this.createPayLogExtends(appId));
        return this.pay0(appId, payLog, returnUrl, request);
    }

    private PayLogExtends createPayLogExtends(String appId) {
        PayLogExtends payLogExtends = new PayLogExtends();
        payLogExtends.put((Object)"appId", (Object)appId);
        return payLogExtends;
    }

    protected abstract Object pay0(String var1, PayLog var2, String var3, HttpServletRequest var4);

    protected abstract String getNotifyUrl(String var1);

    protected final void fillRequestData(String appId, String returnUrl, AlipayRequest<?> request, AlipayObject bizModel) {
        request.setNotifyUrl(this.payProperties.getNotifyUrl() + this.getNotifyUrl(appId));
        if (returnUrl != null) {
            request.setReturnUrl(returnUrl);
        }
        request.setBizModel(bizModel);
    }

    @Autowired
    public void setLogService(PayLogService logService) {
        this.logService = logService;
    }
}

