/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.pay.web.controller.user;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.pay.core.domain.PayLogDTO;
import net.guerlab.smart.pay.core.exception.ExceptionReasonInvalidException;
import net.guerlab.smart.pay.core.exception.ExceptionReasonLengthErrorException;
import net.guerlab.smart.pay.core.exception.PayLogInvalidException;
import net.guerlab.smart.pay.core.searchparams.PayLogSearchParams;
import net.guerlab.smart.pay.service.entity.PayLog;
import net.guerlab.smart.pay.service.service.PayLogService;
import net.guerlab.smart.pay.web.domain.ExceptionDTO;
import net.guerlab.smart.platform.server.controller.BaseFindController;
import net.guerlab.smart.platform.user.api.OperationLogApi;
import net.guerlab.smart.platform.user.auth.UserContextHandler;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u652f\u4ed8\u8bb0\u5f55"})
@RestController(value="/user/payLog")
@RequestMapping(value={"/user/payLog"})
public class PayLogController
extends BaseFindController<PayLogDTO, PayLog, PayLogService, PayLogSearchParams, Long> {
    private OperationLogApi operationLogApi;

    @ApiOperation(value="\u6807\u8bb0\u5f02\u5e38")
    @PostMapping(value={"/{id}/markException"})
    @Transactional(rollbackFor={Exception.class})
    public PayLogDTO markException(@ApiParam(value="id", required=true) @PathVariable Long id, @RequestBody ExceptionDTO dto) {
        String reason = StringUtils.trimToNull((String)dto.getReason());
        if (reason == null) {
            throw new ExceptionReasonInvalidException();
        }
        if (reason.length() > 255) {
            throw new ExceptionReasonLengthErrorException();
        }
        this.findOne0(id);
        ((PayLogService)this.getService()).markException(id, reason);
        this.operationLogApi.add("\u6807\u8bb0\u5f02\u5e38-\u652f\u4ed8\u8bb0\u5f55", UserContextHandler.getUserId(), new Object[]{id, reason});
        return (PayLogDTO)((PayLog)this.findOne0(id)).toDTO();
    }

    @ApiOperation(value="\u79fb\u9664\u6807\u8bb0\u5f02\u5e38")
    @PostMapping(value={"/{id}/removeMarkException"})
    @Transactional(rollbackFor={Exception.class})
    public PayLogDTO removeMarkException(@ApiParam(value="id", required=true) @PathVariable Long id) {
        this.findOne0(id);
        ((PayLogService)this.getService()).removeExceptionMark(id);
        this.operationLogApi.add("\u79fb\u9664\u5f02\u5e38\u6807\u8bb0-\u652f\u4ed8\u8bb0\u5f55", UserContextHandler.getUserId(), new Object[]{id});
        return (PayLogDTO)((PayLog)this.findOne0(id)).toDTO();
    }

    protected ApplicationException nullPointException() {
        return new PayLogInvalidException();
    }

    @Autowired
    public void setOperationLogApi(OperationLogApi operationLogApi) {
        this.operationLogApi = operationLogApi;
    }
}

