package net.guerlab.smart.pay.web.controller.user;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.pay.core.domain.PayLogDTO;
import net.guerlab.smart.pay.core.exception.ExceptionReasonInvalidException;
import net.guerlab.smart.pay.core.exception.ExceptionReasonLengthErrorException;
import net.guerlab.smart.pay.core.exception.PayLogInvalidException;
import net.guerlab.smart.pay.core.searchparams.PayLogSearchParams;
import net.guerlab.smart.pay.service.entity.PayLog;
import net.guerlab.smart.pay.service.service.PayLogService;
import net.guerlab.smart.pay.web.domain.ExceptionDTO;
import net.guerlab.smart.platform.server.controller.BaseFindController;
import net.guerlab.smart.platform.user.api.OperationLogApi;
import net.guerlab.smart.platform.user.auth.UserContextHandler;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;

/**
 * 支付记录
 *
 * @author guer
 */
@Api(tags = "支付记录")
@RestController("/user/payLog")
@RequestMapping("/user/payLog")
public class PayLogController extends BaseFindController<PayLogDTO, PayLog, PayLogService, PayLogSearchParams, Long> {

    private OperationLogApi operationLogApi;

    @ApiOperation("标记异常")
    @PostMapping("/{id}/markException")
    @Transactional(rollbackFor = Exception.class)
    public PayLogDTO markException(@ApiParam(value = "id", required = true) @PathVariable Long id,
            @RequestBody ExceptionDTO dto) {
        String reason = StringUtils.trimToNull(dto.getReason());

        if (reason == null) {
            throw new ExceptionReasonInvalidException();
        } else if (reason.length() > ExceptionDTO.REASON_MAX_LENGTH) {
            throw new ExceptionReasonLengthErrorException();
        }

        findOne0(id);
        getService().markException(id, reason);
        operationLogApi.add("标记异常-支付记录", UserContextHandler.getUserId(), id, reason);

        return findOne0(id).toDTO();
    }

    @ApiOperation("移除标记异常")
    @PostMapping("/{id}/removeMarkException")
    @Transactional(rollbackFor = Exception.class)
    public PayLogDTO removeMarkException(@ApiParam(value = "id", required = true) @PathVariable Long id) {
        findOne0(id);
        getService().removeExceptionMark(id);
        operationLogApi.add("移除异常标记-支付记录", UserContextHandler.getUserId(), id);

        return findOne0(id).toDTO();
    }

    @Override
    protected ApplicationException nullPointException() {
        return new PayLogInvalidException();
    }

    @SuppressWarnings("SpringJavaInjectionPointsAutowiringInspection")
    @Autowired
    public void setOperationLogApi(OperationLogApi operationLogApi) {
        this.operationLogApi = operationLogApi;
    }
}
