/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.pay.web.controller;

import net.guerlab.smart.pay.core.exception.WxPayConfigInvalidException;
import net.guerlab.smart.pay.service.entity.WxPayConfig;
import net.guerlab.smart.pay.service.properties.PayProperties;
import net.guerlab.smart.pay.service.service.WxPayConfigService;
import net.guerlab.smart.pay.web.wx.WxPayService;
import net.guerlab.smart.pay.web.wx.WxPayServiceType;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractWxPayController {
    protected static final String KEY_APP_ID = "appId";
    protected WxPayConfigService configService;
    protected PayProperties payProperties;

    final String getPayChannel() {
        return "WX_" + this.getWxPayServiceType().name();
    }

    protected abstract WxPayServiceType getWxPayServiceType();

    protected WxPayService buildWxPayService(String appId) {
        return this.buildWxPayService(appId, false);
    }

    protected WxPayService buildWxPayService(String appId, boolean checkEnable) {
        WxPayConfig config = (WxPayConfig)this.configService.selectByIdOptional((Object)appId).orElseThrow(WxPayConfigInvalidException::new);
        if (checkEnable && !config.getEnable().booleanValue()) {
            throw new WxPayConfigInvalidException();
        }
        return new WxPayService(this.payProperties, config);
    }

    @Autowired
    public void setConfigService(WxPayConfigService configService) {
        this.configService = configService;
    }

    @Autowired
    public void setPayProperties(PayProperties payProperties) {
        this.payProperties = payProperties;
    }
}

