package net.guerlab.smart.pay.web.controller.wx;

import io.swagger.annotations.Api;
import net.guerlab.smart.pay.web.controller.AbstractWxPayRequestController;
import net.guerlab.smart.pay.web.controller.commons.WxPayNativeChannelNotifyController;
import net.guerlab.smart.pay.web.wx.WxPayServiceType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 支付请求-微信-native
 *
 * @author guer
 */
@Api(tags = "支付请求-微信-native")
@RestController("/wx/payRequest/native")
@RequestMapping("/wx/payRequest/native")
public class WxPayNativeChannelPayController extends AbstractWxPayRequestController {

    @Override
    protected WxPayServiceType getWxPayServiceType() {
        return WxPayServiceType.NATIVE;
    }

    @Override
    public String getNotifyUrl(String appId) {
        return WxPayNativeChannelNotifyController.URL + "/" + appId;
    }
}
