package net.guerlab.smart.pay.web.controller.wx;

import io.swagger.annotations.Api;
import net.guerlab.smart.pay.web.controller.AbstractWxPayRequestController;
import net.guerlab.smart.pay.web.controller.commons.WxPayJsApiChannelNotifyController;
import net.guerlab.smart.pay.web.wx.WxPayServiceType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 支付请求-微信-jsapi
 *
 * @author guer
 */
@Api(tags = "支付请求-微信-jsapi")
@RestController("/wx/payRequest/jsapi")
@RequestMapping("/wx/payRequest/jsapi")
public class WxPayJsApiChannelPayController extends AbstractWxPayRequestController {

    @Override
    protected WxPayServiceType getWxPayServiceType() {
        return WxPayServiceType.JSAPI;
    }

    @Override
    public String getNotifyUrl(String appId) {
        return WxPayJsApiChannelNotifyController.URL + "/" + appId;
    }
}
