package net.guerlab.smart.pay.web.controller.wx;

import io.swagger.annotations.Api;
import net.guerlab.smart.pay.web.controller.AbstractWxPayRequestController;
import net.guerlab.smart.pay.web.controller.commons.WxPayH5ChannelNotifyController;
import net.guerlab.smart.pay.web.wx.WxPayServiceType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 支付请求-微信-h5
 *
 * @author guer
 */
@Api(tags = "支付请求-微信-h5")
@RestController("/wx/payRequest/h5")
@RequestMapping("/wx/payRequest/h5")
public class WxPayH5ChannelPayController extends AbstractWxPayRequestController {

    @Override
    protected WxPayServiceType getWxPayServiceType() {
        return WxPayServiceType.H5;
    }

    @Override
    public String getNotifyUrl(String appId) {
        return WxPayH5ChannelNotifyController.URL + "/" + appId;
    }
}
