package net.guerlab.smart.pay.web.controller.wx;

import io.swagger.annotations.Api;
import net.guerlab.smart.pay.web.controller.AbstractWxPayRequestController;
import net.guerlab.smart.pay.web.controller.commons.WxPayAppChannelNotifyController;
import net.guerlab.smart.pay.web.wx.WxPayServiceType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 支付请求-微信-app
 *
 * @author guer
 */
@Api(tags = "支付请求-微信-app")
@RestController("/wx/payRequest/app")
@RequestMapping("/wx/payRequest/app")
public class WxPayAppChannelPayController extends AbstractWxPayRequestController {

    @Override
    protected WxPayServiceType getWxPayServiceType() {
        return WxPayServiceType.APP;
    }

    @Override
    public String getNotifyUrl(String appId) {
        return WxPayAppChannelNotifyController.URL + "/" + appId;
    }
}
