package net.guerlab.smart.pay.web.controller.user;

import io.swagger.annotations.Api;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.pay.core.domain.PayLogNotifyDTO;
import net.guerlab.smart.pay.core.exception.PayLogNotifyInvalidException;
import net.guerlab.smart.pay.core.searchparams.PayLogNotifySearchParams;
import net.guerlab.smart.pay.service.entity.PayLogNotify;
import net.guerlab.smart.pay.service.service.PayLogNotifyService;
import net.guerlab.smart.platform.server.controller.BaseFindController;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 支付记录通知
 *
 * @author guer
 */
@Api(tags = "支付记录通知")
@RestController("/user/payLogNotify")
@RequestMapping("/user/payLogNotify")
public class PayLogNotifyController
        extends BaseFindController<PayLogNotifyDTO, PayLogNotify, PayLogNotifyService, PayLogNotifySearchParams, Long> {

    @Override
    protected ApplicationException nullPointException() {
        return new PayLogNotifyInvalidException();
    }
}
