package net.guerlab.smart.pay.web.controller.commons;

import io.swagger.annotations.Api;
import net.guerlab.smart.pay.web.controller.AbstractWxPayNotifyController;
import net.guerlab.smart.pay.web.wx.WxPayServiceType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 支付回调-微信-h5
 *
 * @author guer
 */
@Api(tags = "支付回调-微信-h5")
@RestController(WxPayH5ChannelNotifyController.URL)
@RequestMapping(WxPayH5ChannelNotifyController.URL)
public class WxPayH5ChannelNotifyController extends AbstractWxPayNotifyController {

    public static final String URL = "/commons/notify/wx/h5";

    @Override
    protected WxPayServiceType getWxPayServiceType() {
        return WxPayServiceType.H5;
    }
}
