package net.guerlab.smart.pay.web.wx;

import com.github.binarywang.wxpay.bean.request.WxPayUnifiedOrderRequest;
import com.github.binarywang.wxpay.config.WxPayConfig;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.impl.WxPayServiceApacheHttpImpl;
import lombok.Getter;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.commons.random.RandomUtil;

/**
 * 微信支付服务
 *
 * @author guer
 */
@Getter
public class WxPayService extends WxPayServiceApacheHttpImpl {

    private final WxPayProperties properties;

    private final ThreadLocal<String> appId = new ThreadLocal<>();

    WxPayService(WxPayProperties properties) {
        this.properties = properties;
        config = new WxPayConfig();
        config.setMchId(properties.getMchId());
        config.setMchKey(properties.getMchKey());
        config.setSubAppId(properties.getSubAppId());
        config.setSubMchId(properties.getSubMchId());
        config.setKeyPath(properties.getKeyPath());
    }

    @Override
    public WxPayConfig getConfig() {
        WxPayConfig parent = super.getConfig();
        WxPayConfig config = new WxPayConfig();
        config.setAppId(appId.get());
        config.setMchId(parent.getMchId());
        config.setMchKey(parent.getMchKey());
        config.setSubAppId(parent.getSubAppId());
        config.setSubMchId(parent.getSubMchId());
        config.setKeyPath(parent.getKeyPath());

        return config;
    }

    @Override
    public <T> T createOrder(WxPayUnifiedOrderRequest request) {
        appId.set(request.getAppid());
        request.setMchId(properties.getMchId());
        request.setSubAppId(properties.getSubAppId());
        request.setSubMchId(properties.getSubMchId());
        request.setNonceStr(RandomUtil.nextString(6));
        request.setNotifyUrl(properties.getNotifyUrl() + request.getNotifyUrl());

        try {
            return super.createOrder(request);
        } catch (WxPayException e) {
            throw new ApplicationException(e.getErrCodeDes());
        } finally {
            appId.remove();
        }
    }
}
