package net.guerlab.smart.pay.web.controller.user;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.pay.core.domain.PayLogExtends;
import net.guerlab.smart.pay.core.domain.PayOrderDTO;
import net.guerlab.smart.pay.core.enums.PayStatus;
import net.guerlab.smart.pay.core.exception.PayOrderInvalidException;
import net.guerlab.smart.pay.core.exception.PayStatusErrorException;
import net.guerlab.smart.pay.core.searchparams.PayOrderSearchParams;
import net.guerlab.smart.pay.service.entity.PayLog;
import net.guerlab.smart.pay.service.entity.PayOrder;
import net.guerlab.smart.pay.service.service.PayLogService;
import net.guerlab.smart.pay.service.service.PayOrderService;
import net.guerlab.smart.platform.server.controller.BaseFindController;
import net.guerlab.smart.platform.user.api.OperationLogApi;
import net.guerlab.smart.platform.user.auth.UserContextHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 支付订单
 *
 * @author guer
 */
@Api(tags = "支付订单")
@RestController("/user/payOrder")
@RequestMapping("/user/payOrder")
public class PayOrderController
        extends BaseFindController<PayOrderDTO, PayOrder, PayOrderService, PayOrderSearchParams, Long> {

    /**
     * 支付记录服务
     */
    private PayLogService logService;

    private OperationLogApi operationLogApi;

    @Override
    protected ApplicationException nullPointException() {
        return new PayOrderInvalidException();
    }

    @ApiOperation("确认支付")
    @PostMapping("/{id}/confirmPayed")
    @Transactional(rollbackFor = Exception.class)
    public PayOrderDTO confirmPayed(@ApiParam(value = "id", required = true) @PathVariable Long id) {
        PayOrder payOrder = findOne0(id);

        if (payOrder.getPayStatus() != PayStatus.WAIT_PAY) {
            throw new PayStatusErrorException();
        }

        PayLogExtends payLogExtends = new PayLogExtends();
        payLogExtends.put("operation_userId", UserContextHandler.getUserIdString());
        payLogExtends.put("operation_name", UserContextHandler.getName());
        payLogExtends.put("operation_departmentId", UserContextHandler.getDepartmentIdString());
        payLogExtends.put("operation_departmentName", UserContextHandler.getDepartmentName());

        PayLog payLog = logService.create(id, "MANUAL_CONFIRM", payLogExtends);
        payLog.setVersion(1L);
        logService.payed(payLog);

        operationLogApi.add("确认支付", UserContextHandler.getUserId(), payOrder);

        return findOne0(id).toDTO();
    }

    @Autowired
    public void setLogService(PayLogService logService) {
        this.logService = logService;
    }

    @SuppressWarnings("SpringJavaInjectionPointsAutowiringInspection")
    @Autowired
    public void setOperationLogApi(OperationLogApi operationLogApi) {
        this.operationLogApi = operationLogApi;
    }
}
