/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.pay.web.controller.user;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.pay.core.domain.PayLogExtends;
import net.guerlab.smart.pay.core.domain.PayOrderDTO;
import net.guerlab.smart.pay.core.enums.PayStatus;
import net.guerlab.smart.pay.core.exception.PayOrderInvalidException;
import net.guerlab.smart.pay.core.exception.PayStatusErrorException;
import net.guerlab.smart.pay.core.searchparams.PayOrderSearchParams;
import net.guerlab.smart.pay.service.entity.PayLog;
import net.guerlab.smart.pay.service.entity.PayOrder;
import net.guerlab.smart.pay.service.service.PayLogService;
import net.guerlab.smart.pay.service.service.PayOrderService;
import net.guerlab.smart.platform.server.controller.BaseFindController;
import net.guerlab.smart.platform.user.api.OperationLogApi;
import net.guerlab.smart.platform.user.auth.UserContextHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u652f\u4ed8\u8ba2\u5355"})
@RestController(value="/user/payOrder")
@RequestMapping(value={"/user/payOrder"})
public class PayOrderController
extends BaseFindController<PayOrderDTO, PayOrder, PayOrderService, PayOrderSearchParams, Long> {
    private PayLogService logService;
    private OperationLogApi operationLogApi;

    protected ApplicationException nullPointException() {
        return new PayOrderInvalidException();
    }

    @ApiOperation(value="\u786e\u8ba4\u652f\u4ed8")
    @PostMapping(value={"/{id}/confirmPayed"})
    @Transactional(rollbackFor={Exception.class})
    public PayOrderDTO confirmPayed(@ApiParam(value="id", required=true) @PathVariable Long id) {
        PayOrder payOrder = (PayOrder)this.findOne0((Object)id);
        if (payOrder.getPayStatus() != PayStatus.WAIT_PAY) {
            throw new PayStatusErrorException();
        }
        PayLogExtends payLogExtends = new PayLogExtends();
        payLogExtends.put((Object)"operation_userId", (Object)UserContextHandler.getUserIdString());
        payLogExtends.put((Object)"operation_name", (Object)UserContextHandler.getName());
        payLogExtends.put((Object)"operation_departmentId", (Object)UserContextHandler.getDepartmentIdString());
        payLogExtends.put((Object)"operation_departmentName", (Object)UserContextHandler.getDepartmentName());
        PayLog payLog = this.logService.create(id, "MANUAL_CONFIRM", payLogExtends);
        payLog.setVersion(Long.valueOf(1L));
        this.logService.payed(payLog);
        this.operationLogApi.add("\u786e\u8ba4\u652f\u4ed8", UserContextHandler.getUserId(), new Object[]{payOrder});
        return (PayOrderDTO)((PayOrder)this.findOne0((Object)id)).toDTO();
    }

    @Autowired
    public void setLogService(PayLogService logService) {
        this.logService = logService;
    }

    @Autowired
    public void setOperationLogApi(OperationLogApi operationLogApi) {
        this.operationLogApi = operationLogApi;
    }
}

