package net.guerlab.smart.pay.web.controller.commons;

import io.swagger.annotations.Api;
import net.guerlab.smart.pay.web.controller.AbstractWxPayRequestController;
import net.guerlab.smart.pay.web.wx.WxPayServiceType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 支付请求-微信-app
 *
 * @author guer
 */
@Api(tags = "支付请求-微信-app")
@RestController("/commons/pay/wx/app")
@RequestMapping("/commons/pay/wx/app")
public class WxPayAppChannelPayController extends AbstractWxPayRequestController {

    @Override
    protected String getPayChannel0() {
        return WxPayServiceType.APP.getTradeType();
    }

    @Override
    public String getNotifyUrl() {
        return "/commons/notify/wx/app";
    }
}
