/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.pay.web.controller;

import com.github.binarywang.wxpay.bean.notify.WxPayNotifyResponse;
import com.github.binarywang.wxpay.bean.notify.WxPayOrderNotifyResult;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;
import net.guerlab.commons.number.NumberHelper;
import net.guerlab.smart.pay.core.enums.PayStatus;
import net.guerlab.smart.pay.service.entity.PayLog;
import net.guerlab.smart.pay.service.entity.PayLogNotify;
import net.guerlab.smart.pay.service.service.PayLogNotifyService;
import net.guerlab.smart.pay.service.service.PayLogService;
import net.guerlab.smart.pay.web.controller.AbstractWxPayController;
import net.guerlab.smart.pay.web.wx.WxPayServiceConstant;
import net.guerlab.spring.commons.annotation.IgnoreResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

public abstract class AbstractWxPayNotifyController
extends AbstractWxPayController {
    private static final Logger log = LoggerFactory.getLogger(AbstractWxPayNotifyController.class);
    private PayLogService logService;
    private PayLogNotifyService notifyService;

    @ApiOperation(value="\u56de\u8c03\u901a\u77e5")
    @PostMapping
    @IgnoreResponseHandler
    public final String notify(@RequestBody String xmlData) throws Exception {
        long payLogId;
        WxPayOrderNotifyResult notifyResult = this.wxPayService.parseOrderNotifyResult(xmlData);
        try {
            payLogId = Long.parseLong(notifyResult.getOutTradeNo());
        }
        catch (Exception e) {
            return WxPayNotifyResponse.fail((String)e.getLocalizedMessage());
        }
        BigDecimal amount = new BigDecimal(notifyResult.getTotalFee()).divide(WxPayServiceConstant.HUNDRED, 2, RoundingMode.FLOOR);
        String appId = notifyResult.getAppid();
        PayLog payLog = (PayLog)this.logService.selectById((Object)payLogId);
        if (payLog == null) {
            return WxPayNotifyResponse.fail((String)"payLog invalid");
        }
        if (!Objects.equals(this.getPayChannel(), payLog.getPayChannel())) {
            return WxPayNotifyResponse.fail((String)("payLog payChannel error, need: " + payLog.getPayChannel() + ", input: " + this.getPayChannel()));
        }
        if (!NumberHelper.isEquals((Comparable)amount, (Comparable)payLog.getAmount())) {
            return WxPayNotifyResponse.fail((String)("payLog amount error, need: " + payLog.getAmount() + ", input: " + amount));
        }
        if (!Objects.equals(appId, payLog.getExtend())) {
            return WxPayNotifyResponse.fail((String)("payLog appId error, need: " + payLog.getExtend() + ", input: " + appId));
        }
        if (payLog.getPayStatus() != PayStatus.WAIT_PAY) {
            return WxPayNotifyResponse.fail((String)("payLog status error: " + payLog.getPayStatus()));
        }
        PayLogNotify payLogNotify = new PayLogNotify();
        payLogNotify.setPayLogId(Long.valueOf(payLogId));
        payLogNotify.setPayOrderId(payLog.getPayOrderId());
        payLogNotify.setBusinessGroup(payLog.getBusinessGroup());
        payLogNotify.setBusinessId(payLog.getBusinessId());
        payLogNotify.setPayChannel(payLog.getPayChannel());
        payLogNotify.setAmount(amount);
        payLogNotify.setOutOrderSn(notifyResult.getTransactionId());
        try {
            this.notifyService.insertSelective((Object)payLogNotify);
        }
        catch (Exception e) {
            log.debug(e.getLocalizedMessage(), (Throwable)e);
        }
        this.logService.payed(payLog);
        return WxPayNotifyResponse.success((String)"OK");
    }

    @Autowired
    public void setLogService(PayLogService logService) {
        this.logService = logService;
    }

    @Autowired
    public void setNotifyService(PayLogNotifyService notifyService) {
        this.notifyService = notifyService;
    }
}

