package net.guerlab.smart.pay.web.controller.user;

import io.swagger.annotations.Api;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.pay.core.domain.PayLogDTO;
import net.guerlab.smart.pay.core.exception.PayLogInvalidException;
import net.guerlab.smart.pay.core.searchparams.PayLogSearchParams;
import net.guerlab.smart.pay.service.entity.PayLog;
import net.guerlab.smart.pay.service.service.PayLogService;
import net.guerlab.smart.platform.server.controller.BaseFindController;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 支付记录
 *
 * @author guer
 */
@Api(tags = "支付记录")
@RestController("/user/payLog")
@RequestMapping("/user/payLog")
public class PayLogController extends BaseFindController<PayLogDTO, PayLog, PayLogService, PayLogSearchParams, Long> {

    @Override
    protected ApplicationException nullPointException() {
        return new PayLogInvalidException();
    }
}
