package net.guerlab.smart.pay.web.controller.commons;

import io.swagger.annotations.Api;
import net.guerlab.smart.pay.service.wx.WxPayServiceType;
import net.guerlab.smart.pay.web.controller.AbstractWxPayRequestController;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 支付请求-微信-native
 *
 * @author guer
 */
@Api(tags = "支付请求-微信-native")
@RestController("/commons/pay/wx/native")
@RequestMapping("/commons/pay/wx/native")
public class WxPayNativeChannelPayController extends AbstractWxPayRequestController {

    @Override
    protected String getPayChannel0() {
        return WxPayServiceType.NATIVE.getTradeType();
    }

    @Override
    public String getNotifyUrl() {
        return "/commons/notify/wx/native";
    }
}
