package net.guerlab.smart.pay.web.controller.commons;

import io.swagger.annotations.Api;
import net.guerlab.smart.pay.service.wx.WxPayServiceType;
import net.guerlab.smart.pay.web.controller.AbstractWxPayRequestController;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 支付请求-微信-jsapi
 *
 * @author guer
 */
@Api(tags = "支付请求-微信-jsapi")
@RestController("/commons/pay/wx/jsapi")
@RequestMapping("/commons/pay/wx/jsapi")
public class WxPayJsApiChannelPayController extends AbstractWxPayRequestController {

    @Override
    protected String getPayChannel0() {
        return WxPayServiceType.JSAPI.getTradeType();
    }

    @Override
    public String getNotifyUrl() {
        return "/commons/notify/wx/jsapi";
    }
}
