package net.guerlab.smart.pay.web.controller;

import net.guerlab.smart.pay.service.wx.WxPayService;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 抽象微信支付控制器
 *
 * @author guer
 */
public abstract class AbstractWxPayController {

    /**
     * 微信支付服务实例
     */
    protected WxPayService wxPayService;

    /**
     * 获取支付渠道名称
     *
     * @return 支付渠道名称
     */
    final String getPayChannel() {
        return "WX_" + getPayChannel0();
    }

    /**
     * 设置微信支付服务实例
     *
     * @param wxPayService
     *         微信支付服务实例
     */
    @Autowired
    public void setWxPayService(WxPayService wxPayService) {
        this.wxPayService = wxPayService;
    }

    /**
     * 获取支付渠道名称
     *
     * @return 支付渠道名称
     */
    protected abstract String getPayChannel0();
}
