package net.guerlab.smart.pay.web.controller.user;

import io.swagger.annotations.Api;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.pay.core.domain.PayOrderDTO;
import net.guerlab.smart.pay.core.exception.PayOrderInvalidException;
import net.guerlab.smart.pay.core.searchparams.PayOrderSearchParams;
import net.guerlab.smart.pay.service.entity.PayOrder;
import net.guerlab.smart.pay.service.service.PayOrderService;
import net.guerlab.smart.platform.server.controller.BaseFindController;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 支付订单
 *
 * @author guer
 */
@Api(tags = "支付订单")
@RestController("/user/payOrder")
@RequestMapping("/user/payOrder")
public class PayOrderController
        extends BaseFindController<PayOrderDTO, PayOrder, PayOrderService, PayOrderSearchParams, Long> {

    @Override
    protected ApplicationException nullPointException() {
        return new PayOrderInvalidException();
    }
}
