package net.guerlab.smart.pay.web.controller.commons;

import io.swagger.annotations.Api;
import net.guerlab.smart.pay.service.wx.WxPayServiceType;
import net.guerlab.smart.pay.web.controller.AbstractWxPayRequestController;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 支付请求-微信-小程序
 *
 * @author guer
 */
@Api(tags = "支付请求-微信-小程序")
@RestController("/commons/pay/wx/miniApp")
@RequestMapping("/commons/pay/wx/miniApp")
public class WxPayMiniAppChannelPayController extends AbstractWxPayRequestController {

    @Override
    protected String getPayChannel0() {
        return WxPayServiceType.MINI_APP.getTradeType();
    }

    @Override
    public String getNotifyUrl() {
        return "/commons/notify/wx/miniApp";
    }
}
