package net.guerlab.smart.pay.stream.domain;

import lombok.Data;
import net.guerlab.smart.pay.core.enums.PayStatus;

import java.time.LocalDateTime;
import java.util.Collection;

/**
 * 多订单状态变更
 *
 * @author guer
 */
@Data
public class MultiPayOrderStatus {

    /**
     * 订单ID集合
     */
    private Collection<Long> payOrderIds;

    /**
     * 变更后的订单状态
     */
    private PayStatus payStatus;

    /**
     * 变更时间
     */
    private LocalDateTime changeTime;
}
