package net.guerlab.smart.pay.stream.binders;

import org.springframework.cloud.stream.annotation.Input;
import org.springframework.messaging.SubscribableChannel;

/**
 * 支付订单状态变更消息订阅者
 * <p>
 * bean: net.guerlab.smart.hospital.pay.core.domain.PayOrderDTO
 *
 * @author guer
 */
public interface PayOrderStatusChangeSubscriberChannel {

    /**
     * binding名称
     */
    String NAME = "pay_order_status_change_input";

    /**
     * 构造支付订单状态变更消息订阅者
     *
     * @return 支付订单状态变更消息订阅者
     */
    @Input(NAME)
    SubscribableChannel input();
}
