package net.guerlab.smart.pay.stream.binders;

import org.springframework.cloud.stream.annotation.Output;
import org.springframework.messaging.MessageChannel;

/**
 * 支付订单状态变更消息发送者
 * <p>
 * bean: net.guerlab.smart.hospital.pay.core.domain.PayOrderDTO
 *
 * @author guer
 */
public interface PayOrderStatusChangeSenderChannel {

    /**
     * binding名称
     */
    @SuppressWarnings("WeakerAccess")
    String NAME = "pay_order_status_change_output";

    /**
     * 构造支付订单状态变更消息发送者
     *
     * @return 支付订单状态变更消息发送者
     */
    @Output(NAME)
    MessageChannel output();
}
