package net.guerlab.smart.pay.stream.binders;

import org.springframework.cloud.stream.annotation.Input;
import org.springframework.messaging.SubscribableChannel;

/**
 * 批量支付订单状态变更消息订阅者
 * <p>
 * bean: net.guerlab.smart.hospital.pay.stream.domain.MultiPayOrderStatus
 *
 * @author guer
 */
public interface MultiPayOrderStatusChangeSubscriberChannel {

    /**
     * binding名称
     */
    String NAME = "pay_order_multi_status_change_input";

    /**
     * 构造批量支付订单状态变更消息订阅者
     *
     * @return 批量支付订单状态变更消息订阅者
     */
    @Input(NAME)
    SubscribableChannel input();
}
