/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.pay.service.cron;

import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import net.guerlab.commons.collection.CollectionUtil;
import net.guerlab.smart.pay.core.enums.PayStatus;
import net.guerlab.smart.pay.core.searchparams.PayOrderSearchParams;
import net.guerlab.smart.pay.service.entity.PayOrder;
import net.guerlab.smart.pay.service.service.PayOrderService;
import net.guerlab.smart.pay.stream.binders.MultiPayOrderStatusChangeSenderChannel;
import net.guerlab.smart.pay.stream.domain.MultiPayOrderStatus;
import net.guerlab.smart.platform.stream.utils.MessageUtils;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.messaging.MessageChannel;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableBinding(value={MultiPayOrderStatusChangeSenderChannel.class})
public class PayOrderCron {
    private PayOrderService payOrderService;
    private MultiPayOrderStatusChangeSenderChannel statusChangeSender;

    @Autowired
    public void setPayOrderService(PayOrderService payOrderService) {
        this.payOrderService = payOrderService;
    }

    @Autowired
    public void setStatusChangeSender(MultiPayOrderStatusChangeSenderChannel statusChangeSender) {
        this.statusChangeSender = statusChangeSender;
    }

    @Scheduled(cron="0 * * * * ?")
    void closeWithPayTimeOut() {
        LocalDateTime now = LocalDateTime.now();
        PayOrderSearchParams selectSearchParams = new PayOrderSearchParams();
        selectSearchParams.setPayStatus(PayStatus.WAIT_PAY);
        selectSearchParams.setPayTimeoutTimeEndWith(now);
        Collection payOrders = this.payOrderService.selectAll((AbstractSearchParams)selectSearchParams);
        List ids = CollectionUtil.toList((Collection)payOrders, PayOrder::getPayOrderId);
        if (ids.isEmpty()) {
            return;
        }
        PayOrderSearchParams updateSearchParams = new PayOrderSearchParams();
        updateSearchParams.setPayOrderIds((Collection)ids);
        PayOrder updateInfo = new PayOrder();
        updateInfo.setPayStatus(PayStatus.TIMEOUT);
        updateInfo.setPayCancelTime(now);
        if (this.payOrderService.update((Object)updateInfo, (AbstractSearchParams)updateSearchParams)) {
            MultiPayOrderStatus multiPayOrderStatus = new MultiPayOrderStatus();
            multiPayOrderStatus.setChangeTime(now);
            multiPayOrderStatus.setPayOrderIds((Collection)ids);
            multiPayOrderStatus.setPayStatus(PayStatus.TIMEOUT);
            MessageUtils.send((MessageChannel)this.statusChangeSender.output(), (Object)multiPayOrderStatus);
        }
    }
}

