/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.pay.service.service.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDateTime;
import net.guerlab.smart.pay.service.entity.NotifyOriginalLog;
import net.guerlab.smart.pay.service.mapper.NotifyOriginalLogMapper;
import net.guerlab.smart.pay.service.service.NotifyOriginalLogService;
import net.guerlab.smart.platform.server.service.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class NotifyOriginalLogServiceImpl
extends BaseServiceImpl<NotifyOriginalLog, Long, NotifyOriginalLogMapper>
implements NotifyOriginalLogService {
    private static final Logger log = LoggerFactory.getLogger(NotifyOriginalLogServiceImpl.class);
    private ObjectMapper objectMapper;

    @Override
    @Async
    public void add(String payChannel, Object originalData, String result) {
        if ((payChannel = StringUtils.trimToNull((String)payChannel)) == null) {
            return;
        }
        NotifyOriginalLog entity = new NotifyOriginalLog();
        entity.setNotifyOriginalLogId(this.sequence.nextId());
        entity.setCreateTime(LocalDateTime.now());
        entity.setPayChannel(payChannel);
        entity.setResult(result);
        try {
            entity.setContent(this.objectMapper.writeValueAsString(originalData));
            ((NotifyOriginalLogMapper)this.mapper).insertSelective(entity);
        }
        catch (Exception e) {
            log.debug(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @Autowired
    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

