package net.guerlab.smart.pay.service.service;

import net.guerlab.smart.pay.service.entity.NotifyOriginalLog;
import net.guerlab.smart.platform.server.service.BaseFindService;

/**
 * 通知原始记录服务
 *
 * @author guer
 */
public interface NotifyOriginalLogService extends BaseFindService<NotifyOriginalLog, Long> {

    /**
     * 添加记录
     *
     * @param payChannel
     *         支付渠道
     * @param originalData
     *         原始数据
     * @param result
     *         响应数据
     */
    void add(String payChannel, Object originalData, String result);

    /**
     * 获取实体类型
     *
     * @return 实体类型
     */
    @Override
    default Class<NotifyOriginalLog> getEntityClass() {
        return NotifyOriginalLog.class;
    }
}
