package net.guerlab.smart.pay.service.mapper;

import net.guerlab.smart.pay.service.entity.PayLogNotify;
import org.apache.ibatis.annotations.Param;
import tk.mybatis.mapper.common.Mapper;

/**
 * 支付记录通知Mapper
 *
 * @author guer
 */
public interface PayLogNotifyMapper extends Mapper<PayLogNotify> {

    /**
     * 标记异常
     *
     * @param payLogNotifyId
     *         支付记录通知ID
     * @param exceptionReason
     *         异常ID
     */
    void markException(@Param("payLogNotifyId") Long payLogNotifyId, @Param("exceptionReason") String exceptionReason);

    /**
     * 移除标记异常
     *
     * @param payLogNotifyId
     *         支付记录通知ID
     */
    void removeExceptionMark(@Param("payLogNotifyId") Long payLogNotifyId);
}
