package net.guerlab.smart.pay.service.entity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import net.guerlab.smart.pay.core.domain.WxPayConfigDTO;
import net.guerlab.smart.platform.commons.entity.BaseEntity;
import net.guerlab.spring.commons.dto.DefaultConvertDTO;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;

/**
 * 微信支付配置
 *
 * @author guer
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Table(name = "pay_wxpay_config")
public class WxPayConfig extends BaseEntity implements DefaultConvertDTO<WxPayConfigDTO> {

    /**
     * 应用ID
     */
    @Id
    private String appId;

    /**
     * 应用名称
     */
    @Column(name = "appName", nullable = false)
    private String appName;

    /**
     * 微信支付商户号
     */
    @Column(name = "mchId", nullable = false)
    private String mchId;

    /**
     * 微信支付商户密钥
     */
    @Column(name = "mchKey", nullable = false)
    private String mchKey;

    /**
     * 服务商模式下的子商户公众账号ID
     */
    private String subAppId;

    /**
     * 服务商模式下的子商户号
     */
    private String subMchId;

    /**
     * p12证书文件内容
     */
    @Column(name = "keyContentBase64", nullable = false)
    private String keyContentBase64;

    /**
     * 启用标志
     */
    @Column(name = "enable", nullable = false)
    private Boolean enable;
}
