package net.guerlab.smart.pay.service.entity;

import lombok.Data;
import net.guerlab.smart.pay.core.domain.PayLogNotifyDTO;
import net.guerlab.spring.commons.dto.DefaultConvertDTO;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 支付记录通知
 *
 * @author guer
 */
@Data
@Table(name = "pay_log_notify")
public class PayLogNotify implements DefaultConvertDTO<PayLogNotifyDTO> {

    /**
     * 支付记录通知ID
     */
    @Id
    private Long payLogNotifyId;

    /**
     * 支付记录ID
     */
    @Column(name = "payLogId", nullable = false, updatable = false)
    private Long payLogId;

    /**
     * 支付订单ID
     */
    @Column(name = "payOrderId", nullable = false, updatable = false)
    private Long payOrderId;

    /**
     * 业务分组
     */
    @Column(name = "businessGroup", nullable = false, updatable = false)
    private String businessGroup;

    /**
     * 业务ID
     */
    @Column(name = "businessId", nullable = false, updatable = false)
    private String businessId;

    /**
     * 支付渠道
     */
    @Column(name = "payChannel", nullable = false, updatable = false)
    private String payChannel;

    /**
     * 金额
     */
    @Column(name = "amount", nullable = false, updatable = false)
    private BigDecimal amount;

    /**
     * 外部订单编号
     */
    @Column(name = "outOrderSn", nullable = false, updatable = false)
    private String outOrderSn;

    /**
     * 创建时间
     */
    @Column(name = "createTime", nullable = false, updatable = false)
    private LocalDateTime createTime;

    /**
     * 异常标志
     */
    @Column(name = "exceptionFlag", nullable = false)
    private Boolean exceptionFlag;

    /**
     * 异常原因
     */
    @Column(name = "exceptionReason", insertable = false)
    private String exceptionReason;

    /**
     * 通过支付记录构造支付记录通知
     *
     * @param payLog
     *         支付记录
     * @return 支付记录通知
     */
    public static PayLogNotify buildByPayLog(PayLog payLog) {
        PayLogNotify payLogNotify = new PayLogNotify();
        payLogNotify.setPayLogId(payLog.getPayLogId());
        payLogNotify.setPayOrderId(payLog.getPayOrderId());
        payLogNotify.setBusinessGroup(payLog.getBusinessGroup());
        payLogNotify.setBusinessId(payLog.getBusinessId());
        payLogNotify.setPayChannel(payLog.getPayChannel());
        payLogNotify.setAmount(payLog.getAmount());

        return payLogNotify;
    }
}
