package net.guerlab.smart.pay.service.entity;

import lombok.Data;
import net.guerlab.smart.pay.core.domain.NotifyOriginalLogDTO;
import net.guerlab.spring.commons.dto.DefaultConvertDTO;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import java.time.LocalDateTime;

/**
 * 通知原始记录
 *
 * @author guer
 */
@Data
@Table(name = "pay_notify_original_log")
public class NotifyOriginalLog implements DefaultConvertDTO<NotifyOriginalLogDTO> {

    /**
     * 通知原始记录ID
     */
    @Id
    private Long notifyOriginalLogId;

    /**
     * 支付渠道
     */
    @Column(name = "payChannel", nullable = false, updatable = false)
    private String payChannel;

    /**
     * 创建时间
     */
    @Column(name = "createTime", nullable = false, updatable = false)
    private LocalDateTime createTime;

    /**
     * 内容
     */
    @Column(name = "content", nullable = false, updatable = false)
    private String content;

    /**
     * 响应
     */
    @Column(name = "result", nullable = false, updatable = false)
    private String result;
}
