/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.pay.service.service.impl;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import net.guerlab.commons.number.NumberHelper;
import net.guerlab.smart.pay.core.enums.PayStatus;
import net.guerlab.smart.pay.core.exception.BusinessGroupInvalidException;
import net.guerlab.smart.pay.core.exception.BusinessGroupLengthErrorException;
import net.guerlab.smart.pay.core.exception.BusinessIdInvalidException;
import net.guerlab.smart.pay.core.exception.BusinessIdLengthErrorException;
import net.guerlab.smart.pay.core.exception.OrderTitleInvalidException;
import net.guerlab.smart.pay.core.exception.OrderTitleLengthErrorException;
import net.guerlab.smart.pay.core.exception.PayAmountInvalidException;
import net.guerlab.smart.pay.core.exception.PayOrderBusinessUniqueTagRepeatException;
import net.guerlab.smart.pay.core.searchparams.PayOrderSearchParams;
import net.guerlab.smart.pay.service.entity.PayOrder;
import net.guerlab.smart.pay.service.mapper.PayOrderMapper;
import net.guerlab.smart.pay.service.properties.PayProperties;
import net.guerlab.smart.pay.service.service.PayOrderService;
import net.guerlab.smart.platform.server.service.BaseServiceImpl;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PayOrderServiceImpl
extends BaseServiceImpl<PayOrder, Long, PayOrderMapper>
implements PayOrderService {
    private static final Logger log = LoggerFactory.getLogger(PayOrderServiceImpl.class);
    private PayProperties payProperties;

    @Override
    public void markException(Long id, String exceptionReason) {
        exceptionReason = StringUtils.trimToNull((String)exceptionReason);
        if (NumberHelper.greaterZero((Number)id) && exceptionReason != null) {
            ((PayOrderMapper)this.mapper).markException(id, exceptionReason);
        }
    }

    @Override
    public void removeExceptionMark(Long id) {
        ((PayOrderMapper)this.mapper).removeExceptionMark(id);
    }

    protected void insertBefore(PayOrder entity) {
        String orderTitle = StringUtils.trimToNull((String)entity.getOrderTitle());
        String businessGroup = StringUtils.trimToNull((String)entity.getBusinessGroup());
        String businessId = StringUtils.trimToNull((String)entity.getBusinessId());
        BigDecimal amount = entity.getAmount();
        if (orderTitle == null) {
            throw new OrderTitleInvalidException();
        }
        if (orderTitle.length() > 255) {
            throw new OrderTitleLengthErrorException();
        }
        if (businessGroup == null) {
            throw new BusinessGroupInvalidException();
        }
        if (businessGroup.length() > 100) {
            throw new BusinessGroupLengthErrorException();
        }
        if (businessId == null) {
            throw new BusinessIdInvalidException();
        }
        if (businessId.length() > 100) {
            throw new BusinessIdLengthErrorException();
        }
        if (!NumberHelper.greaterOrEqualZero((Number)amount)) {
            throw new PayAmountInvalidException();
        }
        PayOrderSearchParams searchParams = new PayOrderSearchParams();
        searchParams.setBusinessGroup(businessGroup);
        searchParams.setBusinessId(businessId);
        if (this.selectCount((AbstractSearchParams)searchParams) > 0) {
            throw new PayOrderBusinessUniqueTagRepeatException();
        }
        boolean payed = !NumberHelper.greaterZero((Number)amount);
        LocalDateTime now = LocalDateTime.now();
        entity.setPayOrderId(this.sequence.nextId());
        entity.setOrderTitle(orderTitle);
        entity.setBusinessGroup(businessGroup);
        entity.setBusinessId(businessId);
        entity.setCreateTime(now);
        entity.setPayTimeoutTime(now.plusMinutes(this.payProperties.getTimeoutMinute()));
        entity.setPayCancelTime(null);
        entity.setExceptionFlag(false);
        entity.setExceptionReason(null);
        if (payed) {
            entity.setPayedTime(now);
            entity.setPayStatus(PayStatus.PAYED);
        } else {
            entity.setPayedTime(null);
            entity.setPayStatus(PayStatus.WAIT_PAY);
        }
    }

    @Autowired
    public void setPayProperties(PayProperties payProperties) {
        this.payProperties = payProperties;
    }
}

