/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.pay.service.service.impl;

import java.time.LocalDateTime;
import net.guerlab.commons.number.NumberHelper;
import net.guerlab.smart.pay.core.exception.OutOrderSnInvalidException;
import net.guerlab.smart.pay.core.exception.PayAmountInvalidException;
import net.guerlab.smart.pay.core.exception.PayChannelInvalidException;
import net.guerlab.smart.pay.core.exception.PayLogIdInvalidException;
import net.guerlab.smart.pay.core.exception.PayOrderIdInvalidException;
import net.guerlab.smart.pay.service.entity.PayLogNotify;
import net.guerlab.smart.pay.service.mapper.PayLogNotifyMapper;
import net.guerlab.smart.pay.service.service.PayLogNotifyService;
import net.guerlab.smart.platform.server.service.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class PayLogNotifyServiceImpl
extends BaseServiceImpl<PayLogNotify, Long, PayLogNotifyMapper>
implements PayLogNotifyService {
    @Override
    public void markException(Long id, String exceptionReason) {
        exceptionReason = StringUtils.trimToNull((String)exceptionReason);
        if (NumberHelper.greaterZero((Number)id) && exceptionReason != null) {
            ((PayLogNotifyMapper)this.mapper).markException(id, exceptionReason);
        }
    }

    @Override
    public void removeExceptionMark(Long id) {
        ((PayLogNotifyMapper)this.mapper).removeExceptionMark(id);
    }

    protected void insertBefore(PayLogNotify entity) {
        String payChannel = StringUtils.trimToNull((String)entity.getPayChannel());
        String outOrderSn = StringUtils.trimToNull((String)entity.getOutOrderSn());
        if (!NumberHelper.greaterOrEqualZero((Number)entity.getPayLogId())) {
            throw new PayLogIdInvalidException();
        }
        if (!NumberHelper.greaterOrEqualZero((Number)entity.getPayOrderId())) {
            throw new PayOrderIdInvalidException();
        }
        if (payChannel == null) {
            throw new PayChannelInvalidException();
        }
        if (!NumberHelper.greaterOrEqualZero((Number)entity.getAmount())) {
            throw new PayAmountInvalidException();
        }
        if (outOrderSn == null) {
            throw new OutOrderSnInvalidException();
        }
        entity.setPayLogNotifyId(this.sequence.nextId());
        entity.setCreateTime(LocalDateTime.now());
        entity.setPayChannel(payChannel);
        entity.setOutOrderSn(outOrderSn);
        entity.setExceptionFlag(false);
        entity.setExceptionReason(null);
    }
}

