/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.pay.service.service.impl;

import net.guerlab.smart.pay.core.exception.AlipayConfigAlipayPublicKeyInvalidException;
import net.guerlab.smart.pay.core.exception.AlipayConfigAppIdInvalidException;
import net.guerlab.smart.pay.core.exception.AlipayConfigAppIdRepeatException;
import net.guerlab.smart.pay.core.exception.AlipayConfigAppNameInvalidException;
import net.guerlab.smart.pay.core.exception.AlipayConfigAppNameLengthErrorException;
import net.guerlab.smart.pay.core.exception.AlipayConfigPrivateKeyInvalidException;
import net.guerlab.smart.pay.service.entity.AlipayConfig;
import net.guerlab.smart.pay.service.mapper.AlipayConfigMapper;
import net.guerlab.smart.pay.service.service.AlipayConfigService;
import net.guerlab.smart.platform.server.service.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class AlipayConfigServiceImpl
extends BaseServiceImpl<AlipayConfig, String, AlipayConfigMapper>
implements AlipayConfigService {
    protected void insertBefore(AlipayConfig entity) {
        String appId = StringUtils.trimToNull((String)entity.getAppId());
        String appName = StringUtils.trimToNull((String)entity.getAppName());
        String privateKey = StringUtils.trimToNull((String)entity.getPrivateKey());
        String alipayPublicKey = StringUtils.trimToNull((String)entity.getAlipayPublicKey());
        if (appId == null) {
            throw new AlipayConfigAppIdInvalidException();
        }
        if (this.selectById(appId) != null) {
            throw new AlipayConfigAppIdRepeatException();
        }
        if (appName == null) {
            throw new AlipayConfigAppNameInvalidException();
        }
        if (appName.length() > 255) {
            throw new AlipayConfigAppNameLengthErrorException();
        }
        if (privateKey == null) {
            throw new AlipayConfigPrivateKeyInvalidException();
        }
        if (alipayPublicKey == null) {
            throw new AlipayConfigAlipayPublicKeyInvalidException();
        }
        entity.setAppId(appId);
        entity.setAppName(appName);
        entity.setPrivateKey(privateKey);
        entity.setAlipayPublicKey(alipayPublicKey);
        if (entity.getEnable() == null) {
            entity.setEnable(true);
        }
        if (entity.getEnableDevEnv() == null) {
            entity.setEnableDevEnv(false);
        }
    }

    protected void updateBefore(AlipayConfig entity) {
        String appName = StringUtils.trimToNull((String)entity.getAppName());
        if (appName != null && appName.length() > 255) {
            throw new AlipayConfigAppNameLengthErrorException();
        }
        entity.setAppName(appName);
        entity.setPrivateKey(StringUtils.trimToNull((String)entity.getPrivateKey()));
        entity.setAlipayPublicKey(StringUtils.trimToNull((String)entity.getAlipayPublicKey()));
    }
}

