package net.guerlab.smart.pay.service.service;

import net.guerlab.smart.pay.service.entity.PayOrder;
import net.guerlab.smart.platform.server.service.BaseService;

/**
 * 支付订单服务
 *
 * @author guer
 */
public interface PayOrderService extends BaseService<PayOrder, Long> {

    /**
     * 标记异常
     *
     * @param payOrderId
     *         支付订单ID
     * @param exceptionReason
     *         异常ID
     */
    void markException(Long payOrderId, String exceptionReason);

    /**
     * 移除标记异常
     *
     * @param payOrderId
     *         支付订单ID
     */
    void removeExceptionMark(Long payOrderId);

    /**
     * 获取实体类型
     *
     * @return 实体类型
     */
    @Override
    default Class<PayOrder> getEntityClass() {
        return PayOrder.class;
    }
}
