package net.guerlab.smart.pay.service.service;

import net.guerlab.smart.pay.service.entity.PayLogNotify;
import net.guerlab.smart.platform.server.service.BaseFindService;
import net.guerlab.smart.platform.server.service.BaseSaveService;

/**
 * 支付记录通知服务
 *
 * @author guer
 */
public interface PayLogNotifyService extends BaseFindService<PayLogNotify, Long>, BaseSaveService<PayLogNotify> {

    /**
     * 标记异常
     *
     * @param payLogId
     *         支付记录ID
     * @param exceptionReason
     *         异常ID
     */
    void markException(Long payLogId, String exceptionReason);

    /**
     * 移除标记异常
     *
     * @param payLogId
     *         支付记录ID
     */
    void removeExceptionMark(Long payLogId);

    /**
     * 获取实体类型
     *
     * @return 实体类型
     */
    @Override
    default Class<PayLogNotify> getEntityClass() {
        return PayLogNotify.class;
    }
}
